/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.sandesha.RMMessageContext;
import org.apache.sandesha.SandeshaContext;

public class WSClientPropertyValidator {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    private static final String m_className = "WSClientPropertyValidator";

    public static String _get_FILE_DATE() {
        return "$Date:   16 Oct 2006 20:58:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    public static synchronized RMMessageContext validate(Call call) throws AxisFault {
        String m_method = "validate";
        try {
            logger.entering(m_className, m_method);
            RMMessageContext rmMessageContext = null;
            boolean inOut = WSClientPropertyValidator.getInOut(call);
            long msgNumber = WSClientPropertyValidator.getMessageNumber(call);
            boolean lastMessage = WSClientPropertyValidator.getLastMessage(call);
            boolean sync = WSClientPropertyValidator.getSync(call);
            String action = WSClientPropertyValidator.getAction(call);
            String sourceURL = null;
            String from = WSClientPropertyValidator.getFrom(call);
            String replyTo = WSClientPropertyValidator.getReplyTo(call);
            String acksTo = WSClientPropertyValidator.getAcksTo(call);
            String to = WSClientPropertyValidator.getTo(call);
            String faultTo = WSClientPropertyValidator.getFaultTo(call);
            boolean sendOffer = WSClientPropertyValidator.getOffer(call);
            String key = WSClientPropertyValidator.getKey(call);
            SandeshaContext ctx = WSClientPropertyValidator.getCtx(call);
            try {
                sourceURL = WSClientPropertyValidator.getSourceURL(call);
            }
            catch (Exception e) {
                throw new AxisFault(e.getMessage());
            }
            String errorMsg = WSClientPropertyValidator.getValidated(msgNumber, action, replyTo, sync, inOut);
            if (errorMsg == null) {
                rmMessageContext = new RMMessageContext();
                rmMessageContext.setSync(sync);
                rmMessageContext.setHasResponse(inOut);
                rmMessageContext.setMsgNumber(msgNumber);
                rmMessageContext.setLastMessage(lastMessage);
                rmMessageContext.setSourceURL(sourceURL);
                rmMessageContext.setSequenceID(key);
                rmMessageContext.setReplyTo(replyTo);
                rmMessageContext.setFrom(from);
                rmMessageContext.setAction(action);
                rmMessageContext.setAcksTo(acksTo);
                rmMessageContext.setTo(to);
                rmMessageContext.setFaultTo(faultTo);
                rmMessageContext.setSendOffer(sendOffer);
                rmMessageContext.setCtx(ctx);
                RMMessageContext rMMessageContext = rmMessageContext;
                return rMMessageContext;
            }
            try {
                throw new AxisFault(errorMsg);
            }
            catch (AxisFault ex) {
                logger.throwing(m_className, m_method, ex);
                throw ex;
            }
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private static SandeshaContext getCtx(Call call) {
        return (SandeshaContext)call.getProperty("context");
    }

    private static String getKey(Call call) {
        return (String)call.getProperty("callKey");
    }

    private static boolean getOffer(Call call) {
        Boolean sendOffer = (Boolean)call.getProperty("offer");
        if (sendOffer != null) {
            return sendOffer;
        }
        return false;
    }

    private static String getFaultTo(Call call) {
        String faultTo = (String)call.getProperty("faultTo");
        if (faultTo != null) {
            return faultTo;
        }
        return null;
    }

    private static String getTo(Call call) {
        String to = (String)call.getProperty("to");
        if (to != null) {
            return to;
        }
        return call.getTargetEndpointAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getInOut(Call call) {
        String m_method = "getInOut";
        logger.entering(m_className, m_method);
        boolean ret = false;
        try {
            QName returnQName = call.getReturnType();
            if (returnQName != null) {
                boolean bl = true;
                return bl;
            }
            Object mep = call.getProperty("mep");
            if (mep != null && mep instanceof Short) {
                short value = (Short)mep;
                boolean bl = ret = value == 1;
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "InOut = " + ret);
                }
                boolean bl2 = ret;
                return bl2;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "InOut = false");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private static String getAction(Call call) {
        String action = (String)call.getProperty("action");
        if (action != null) {
            return action;
        }
        return null;
    }

    private static String getAcksTo(Call call) {
        String acksTo = (String)call.getProperty("acksTo");
        if (acksTo != null) {
            return acksTo;
        }
        return null;
    }

    private static boolean getSync(Call call) {
        Boolean synchronous = (Boolean)call.getProperty("sync");
        if (synchronous != null) {
            return synchronous;
        }
        return false;
    }

    private static String getSourceURL(Call call) throws Exception {
        String sourceURL = null;
        sourceURL = (String)call.getProperty("sourceURL");
        if (sourceURL != null) {
            return sourceURL;
        }
        throw new Exception("No Source URL specified");
    }

    private static long getMessageNumber(Call call) {
        Object temp = call.getProperty("msgNumber");
        SandeshaContext ctx = (SandeshaContext)call.getProperty("context");
        long msgNo = ctx.getMessageNumber();
        if (temp == null) {
            ctx.setMessageNumber(++msgNo);
        } else {
            msgNo = (Long)call.getProperty("msgNumber");
        }
        return msgNo;
    }

    private static boolean getLastMessage(Call call) {
        Boolean lastMessage = (Boolean)call.getProperty("lastMessage");
        if (lastMessage != null) {
            return lastMessage;
        }
        return false;
    }

    private static String getValidated(long msgNumber, String action, String replyTo, boolean sync, boolean inOut) {
        String errorMsg = null;
        if (sync && inOut && replyTo == null) {
            errorMsg = "ERROR: To perform the operation, ReplyTo address must be specified. This EPR will not be the Sandesha end point. If it should be Sandesha end point, please set the propety 'sync' to false in call.";
            return errorMsg;
        }
        if (action == null) {
            errorMsg = "ERROR: Message Number Not Specified or Action is null";
            return errorMsg;
        }
        return errorMsg;
    }

    private static String getFrom(Call call) {
        return (String)call.getProperty("from");
    }

    private static String getReplyTo(Call call) {
        return (String)call.getProperty("replyTo");
    }
}

